﻿import com.gskinner.util.PList;
//
class com.gskinner.util.UserPreferences {
        // JSFL Stuff
        //public static var JSFL_FILE = "gskinner/jsfl/UserPreferences.jsfl";
		public static var JSFL_FILE = 'Scaleform/jsfl/UserPreferences.jsfl'
        public static var SCRIPT_URL:String = "fl.runScript(fl.configURI + \"" + JSFL_FILE + "\", \"%FUNCTION%\", \"%URL%\", \"%XML%\");";
        //
        // Instance props
        private var tempModel:Object;
        public var model:Object;
        public var xmlSource:XML;
        public var file:String;
        public var status:Boolean = false;

// Initialization
        public function UserPreferences(p_url:String) {
                if (p_url == undefined) { return; }
                var dotPosition:Number = p_url.indexOf(".");
                if (dotPosition == -1) {
                        p_url += ".plist";
                } else if (dotPosition == p_url.length-1) {
                        p_url += "plist";
                }
                file = p_url;
                
                model = {};
				
                var url:String = compileURL("loadPreferences");
                var prefs:String = MMExecute(url);
                if (prefs) {
                        xmlSource = new XML();
                        xmlSource.ignoreWhite = true;
                        xmlSource.parseXML(prefs);
                        fromXML(xmlSource);
                } else {
                        model = {};
                }
				model = (model== undefined) ? {} : model;
        }

// Public Methods
        public function getPref(p_key:String) {
                return model[p_key];
        }
        public function setPref(p_key:String, p_val, p_save:Boolean):Boolean {
                model[p_key] = p_val;
                if (p_save == false) { return; }
                return save();
        }
        public function removePref(p_key:String, p_save:Boolean):Boolean {
                delete model[p_key];
                if (p_save == false) { return; }
                return save();
        }
        public function remove():Boolean {
                var deleteURL:String = compileURL("deleteFile");
                var success:Boolean = MMExecute(deleteURL);
                if (success) {
                        delete (model);
                        delete (xmlSource);
                }
                status = false;
                return success;
        }
        public function save():Boolean {
                var xmlStr:String = PList.serialize(model).toString();
                xmlStr = xmlStr.split("\"").join("\\\"");
                xmlStr = xmlStr.split("\n").join("\\n");
				
               	var saveURL:String = compileURL("savePreferences", xmlStr);
				
               
				var success:Boolean = MMExecute(saveURL);
                return success == "true";
        }
// Private Methods
        private function fromXML(xml:XML):Void {
                model = PList.deserialize(xml);
                status = true;
        }
        //
        private function compileURL(p_function:String, p_xml:String):String {
                var url:String = SCRIPT_URL.split("%FUNCTION%").join(p_function);
                url = url.split("%URL%").join(file);
                var x:String = (p_xml != undefined) ? p_xml : "";
                url = url.split("%XML%").join(x);
                return url;
        }
}